static char *euwhat_lsdate_c = "@(!--#) @(#) lsdate.c, version 004, 10-july-2003";

/*
 *  lsdate
 *
 *  display date and time of a file(s) modification time.
 *  go right down to actual second.
 *  output following format:
 *
 *    YYYY/MM/DD HH:MM:SS filename
 *
 */

/*
 *  includes
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#include <time.h>

/*
 *  defines
 */

#define MAX_LINE_LENGTH 4096

/*
 *  global variables
 */

char *progname;
int   retcode;

/****************************************************************************/

lsdate(fname)
  char *fname;
{
  struct stat stbuf;
  time_t      modtime;
  struct tm  *t;

  if (stat(fname, &stbuf) == -1)
  {
    fprintf(stderr, "%s: cannot stat \"%s\"\n", progname, fname);
    retcode = 1;
  }
  else
  {
    modtime = stbuf.st_mtime;

    t = localtime(&modtime);

    printf("%04d/%02d/%02d", (t->tm_year)+1900, (t->tm_mon)+1, t->tm_mday);
    printf(" %02d:%02d:%02d", t->tm_hour, t->tm_min, t->tm_sec);
    printf(" %s\n", fname);
  }

  return;
}

/****************************************************************************/

lose_newline(s)
  char *s;
{
  size_t len;

  len = strlen(s);

  if (len > 0)
  {
    if (s[len-1] == '\n')
    {
      s[len-1] = '\0';
    }
  }

  return;
}

/****************************************************************************/

lsdate_stdin()
{
  char  line[MAX_LINE_LENGTH];

  while (fgets(line, MAX_LINE_LENGTH - 1, stdin) != NULL)
  {
    lose_newline(line);

    if (*line != '\0')
    {
      lsdate(line);
    }
  }

  return;
}

/*** Main *******************************************************************/

main(argc, argv)
  int   argc;
  char *argv[];
{
  int   arg;

  progname = "lsdate";

  if (argc == 2)
  {
    if (strcmp(argv[1], "--version") == 0)
    {
      fprintf(stderr, "\n%s\n\n", euwhat_lsdate_c);
      fprintf(stderr, "    The hours are good but, come to think of it,\n");
      fprintf(stderr, "    most of the minutes are pretty lousy.\n\n");
      exit(2);
    }
  }

  retcode = 0;

  if (argc == 1)
  {
    lsdate_stdin();
  }
  else
  {
    for (arg=1; arg < argc; arg++)
    {
      lsdate(argv[arg]);
    }
  }

  exit(retcode);
}

/* end of file */
